# Meta‑analyses on Corporate Social Responsibility (CSR): a literature review

Patrick Velte1 $\textcircled{1}$

Received: 6 December 2020 / Accepted: 10 February 2021 / Published online: 18 March 2021   
$\circledcirc$ The Author(s) 2021

# Abstract

This paper addresses quantitative meta-analyses on corporate governance-related determinants and frms’ (non) fnancial consequences of Corporate Social Responsibility (CSR). Legitimacy theory as our theoretical framework assumes that, through a social contract, a company must fulfl the respective society’s values and expectations and gain legitimacy. We also rely on the business case argument, assuming a positive relationship between CSR and fnancial outcomes of the frm. This analysis focusses on 54 quantitative meta-analyses on CSR and includes a structured literature review in order to increase our knowledge, which corporate governance variables and proxies of frm’s (non) fnancial outcome have been heavily included in archival research, and if there is an overall impact of these variables. Prior metaanalyses indicate that board independence, board gender diversity, and board size have a positive impact on CSR performance. Moreover, both CSR performance and environmental performance increase fnancial performance. This literature review makes a useful contribution to prior studies by summarizing the overall impact of corporate governance variables on CSR and their (non) fnancial consequences and by deducing recommendations for future research.

Keywords Corporate Social Responsibility $\cdot$ Corporate governance $\cdot$ Legitimacy theory $\cdot$ Literature Review $\cdot$ Meta-analysis

JEL Classifcation ${ \bf G } 3 2 \cdot { \bf G } 4 1 \cdot { \bf M } 4 1 \cdot { \bf M } 4 2 \cdot { \bf M } 4 8$

# 1 Introduction

Since the fnancial crisis of 2008–09, public interest entities (PIEs) are very active in Corporate Social Responsibility (CSR) strategies in line with the triple bottom line (economic, social, and environmental goals). In view of various (inter) national frameworks, e.g., the Global Reporting Initiative (GRI) Standards and their voluntary character in many regimes, stakeholders criticize the reliability of CSR reports and included CSR performance measures due to greenwashing policy and information overload (Huang and Watson 2015). CSR performance measures and reports are connected with increased managerial discretion as a potential self-impression tool (Huang and Watson 2015). According to the famous business case argument for CSR (Schaltegger et al. 2019), successful CSR strategies should lead to better frm’s (non) fnancial performance and increased frm value. A proper corporate governance system is needed to decrease greenwashing and information overload (Ortas et  al. 2017) and to increase frm reputation. Especially, monitoring duties of non executive directors and the implementation of incentive-based compensation systems for top managers should strengthen substantial CSR management systems and avoid symbolic CSR activities (GuerreroVillegas et al. 2018).

In line with the increased relevance in business practice, CSR represents a key topic in empirical-quantitative research. Next to numerous literature reviews on the business case of CSR (Schaltegger et  al. 2019) who focus the variation of diferent theories, research methods and CSR proxies within this feld, quantitative meta-analyses on CSR research become important during the last few years (e.g., Majumder et al. 2017; Cafri et al. 2010). As there are very diferent results in empirical-quantitative CSR studies, meta-analyses statistically summarize the existing research and increase the validity of CSR research and its implications. Another main goal of meta-analyses is the implementation of relevant moderator analysis across multiple studies (Velte 2019a; Friede et al. 2015; Parmigiani and Rivera-Santos 2011). As we notice an increased amount of CSR-related metaanalyses during the last years, we are surprised that no literature review on CSR meta-analyses exists so far. In more detail, we just identify four literature reviews on meta-analyses in business administration: a literature review of meta-analyses on accounting (Khlif and Chalmers 2015), auditing (Hay 2019), fnance (GeyerKlingeberg et al. 2020) and accounting, auditing and corporate governance (Velte 2019b). We see a major research gap on conducting a literature review on prior CSR meta-analyses in view of the following reasons: First, archival CSR research has been increased during the last decade and show heterogeneous results, leading to increased use of meta-analyses on CSR. Prior meta-analyses have used diferent methods, variables, and moderators, stressing the need to structure the results with the help of a literature review. Second, in line with legitimacy theory and the business case argument for CSR, it is questionable whether prior CSR meta-analyses reported a positive impact of corporate governance on CSR and whether CSR is connected with positive (non) fnancial consequences. We thus question whether corporate governance as a monitoring and incentive tool is needed for top managers to decrease opportunistic behaviour and strengthen their CSR eforts. Third, as CSR proxies are also very heterogeneous in practice and research, we know very little about the overall impact of corporate governance on diferent CSR proxies and their consequences, based on meta-analyses. We thus diferentiate between the most used variables in prior research: CSR performance, reporting and their related subpillars (e.g., environmental or carbon issues), board gender diversity, Sustainable Supply Chain Management (SSCM) and Socially Responsible Investments (SRI). Fourth, one of the main goals of meta-analyses is to include relevant moderator and mediator analyses. Signifcant results may be related to moderating and meditating variables, so that it increases our knowledge on factors that may have an impact on the business case for CSR. Therefore, the goal of our study is to evaluate 54 quantitative CSR meta-analyses by addressing the following main research questions:

1. What are the main corporate governance-related determinants of CSR? 2. What are the key frms’ (non) fnancial consequences of CSR? 3. Which moderator and mediator variables have been included in prior CSR metaanalyses?

Our literature review on CSR meta-analyses indicates that the majority of included studies has focussed on the CSR-fnancial performance-link. In view of the key corporate governance-related determinants, we note that board independence, board gender diversity and board size have a positive impact on CSR performance. Thus, corporate governance tools can fulfl a main incentive and monitoring tool for top managers in order to increase their CSR eforts. Moreover, in line with our business case argument, CSR (environmental) performance leads to increased fnancial performance according to our literature review. Thus, shareholders and other stakeholder groups include successful CSR strategies in their decision-making and this may lead to an increased frm value.

The following review provides useful information for researchers, regulators, and practitioners, which may stimulate future researchers to conduct more quantitative meta-analyses on CSR. Furthermore, business practice and regulatory bodies should be aware of the great need to strengthen the comparability of CSR performance and related CSR reporting tools. Regulators may be encouraged to implement stricter regulations on sustainable corporate governance in order to decrease greenwashing policies and lower information overload with regard to CSR.

This article is structured as follows: after introducing our legitimacy theoretical framework and our research framework (Sect. 2), we portray the main results of our literature view on CSR meta-analyses (Sect.  3). Then, we stress main restrictions of existing research and present selective recommendations for future research activities (Sect. 4). A summary of our results will be focussed in Sect. 5.

# 2 Legitimacy theoretical foundation and research framework

# 2.1 General remarks

Legitimacy theory has established as one of the most important organizational and management theories. This theory assumes that an organization has an implicit social contract with the society in which it operates. This social contract (Shocker and Sethi 1973) should motivate managers to comply with a society’s specifc values, norms and boundaries by implementing adequate structures and processes (Dowling and Pfefer 1975). Thus, the long-term success and survival of a frm is subject to its ability to meet society’s expectations through suitable systems. If a legitimacy gap arises or is detected, organizations adopt legitimating strategies (Fernando and Lawrence 2014).

However, societal values are dynamic (Deegan 2002), especially with regard to CSR. Therefore, legitimization is a continuous process, which is supported by efective tools for communicating organization’s legitimization actions. CSR eforts therefore enhance an organization’s image as a good corporate citizen (O’Donovan 1999). Such legitimization strategies improve an organization’s access to resources, their image and their customer, employee and investor relationships, which will subsequently enhance their competitive position. If society suspects a lack of transparency, its legitimacy sufers (Aguilera et al. 2007).

Heterogeneous stakeholders’ information needs can only be fulflled by the implementation of substantial CSR management systems, e.g., by SRI policy, SSCM, CSR reports and precise CSR performance measures. CSR reporting and the communication of CSR performance represent major challenges in order to gain legitimacy of main stakeholder groups. As greenwashing policy and information overload (Mahoney et al. 2013) are major risks in business practice, stakeholders expect reliable CSR information. Related managerial discretion in CSR and opportunistic behaviour of top managers may be reduced by proper corporate governance systems. Corporate governance is related with internal and external incentive and monitoring tools in order to strengthen CSR strategies in line with stakeholder demands (sustainable corporate governance). Legitimacy theory assumes that CSR strategies can be both symbolic or substantive (Mahoney et al. 2013). Substantive CSR strategies imply a careful implementation of CSR into the frm’s business model and risk management system (Brown and Fraser 2006). An integrative view of economic, environmental, and social goals is required in order to prevent a symbolic use of CSR. Symbolic CSR activities are intended to meet stakeholders’ expectations and enhance public image and fnancial outputs as ofensive greenwashing policy (Maroun 2020). As there is no integration of CSR within the business model and risk management, fnancial and non fnancial performances are analysed separately in this context. This also refers to the separate publication of traditional fnancial statements and CSR reports as a simple marketing tool. Thus, it is not clear, whether corporate governance mechanisms are needed in order to stipulate CSR and whether CSR strategies lead to positive frm’s (non) fnancial performance (Byron and Post 2016). In this literature review, we rely on the business case argument for CSR. The business case argument for CSR proposes that top management follows an “enlightened self-interest” by achieving fnancial goals while considering CSR aspects (Schaltegger et al. 2019) and vice versa. In more detail, management evaluates a trade-of between CSR and fnancial success. In line with frm’s (non) fnancial performance as a consequence of CSR activities, the business case argument also assumes that corporate governance-related pressure may mainly infuence this direction.

Efective corporate governance should put pressure on top managements to implement substantial CSR strategies. Corporate governance can be classifed as a legitimacy tool toward stakeholders’ demands regarding the reliability of CSR activities. The following two main subgroups can be found: internal corporate governance (board composition), and external corporate governance (ownership structure) (e.g., Velte et al. 2020). As internal and external corporate governance represent diferent concepts, a clear diferentiation is justifed. This diferentiation is also very useful to characterize corporate governance regimes. Countries with a clear focus on internal corporate governance (insider systems), e.g., Continental Europe, strengthen their regulations on board efectiveness, e.g., by audit committees. Regimes with a focus on external corporate governance (outsider- or market systems) increase their regulations on shareholder rights and on enforcement to monitor frms and put pressure on top managers to conform with shareholders’ interests.

# 2.2 Internal corporate governance

Internal corporate governance is mainly linked to board composition. Management should act in line with stakeholders’ interests in their investment and strategic decisions. The board of directors, at the apex of internal control systems, advise and monitor the management (executive directors) and has to duty to hire, fre, and to compensate the senior management (Gillan 2006; Shleifer and Visny 1997). Research on corporate boards has concentrated on the links between board structure and frm value. Legitimacy theory assumes that board efectiveness leads to increased CSR activities (e.g., performance and reporting) to improve frm reputation and gain social legitimacy. As CSR strategies are linked with restricted objectivity and thus increased managerial discretion, greenwashing behaviour and information overload may threaten stakeholders’ interests. In our literature review, we assume that board composition as board efectiveness will have a positive impact on CSR outputs.

# 2.3 External corporate governance

In line with Shleifer and Vishny (1997), shareholders use monitoring mechanisms to ensure that they will gain a return on their investments. Shareholders, as the residual claimants, elect board members and boards owe a fduciary obligation to shareholders. In line with shareholders, other stakeholders have information needs which have to be addressed by executive directors (Gillan 2006). Normally, shareholder do not just rely on the monitoring by the board of directors. They implement individual monitoring mechanisms to put pressure on the top management to fulfl their goals. Say on pay voting is a major example for active monitoring by shareholders. The degree of monitoring is mainly dependent on the individual ownership structure within a frm. Corporate governance research mainly stresses the monitoring role of institutional investors and blockholders in view of their increased power and infuence on senior managers (Gillan 2006; Shleifer and Visny 1997). From a traditional perspective, investors’ goals mainly rely on fnancial performance. During the last decade, social responsible investors with long-term and non-fnancial preferences have entered the capital market (Velte et  al. 2020). These investors are normally part of institutional investors and blockholders, leading to an increased infuence on frms’ CSR strategies, e.g., climate change policies. Legitimacy theory assumes that strong monitoring by shareholders as (non) fnancial shareholder activism will put pressure on senior management to increase their CSR eforts.

# 2.4 Firms’ (non) fnancial consequences of CSR

We stated in Sect. 2.1 that both internal and external corporate governance are connected with increased CSR activities of the frm. But all corporate governance elements, both the board of directors and shareholders, are not only interested in an appropriate CSR performance and reporting. They also demand an adequate level of fnancial performance to guarantee going concern of the frm. Legitimacy theory assumes that the senior management increases their eforts to reach legitimacy of the society. Firm reputation can only be reached by a conglomeration of fnancial and CSR-related success of frm strategies. CSR eforts can be classifed as “prefnancials” and they will be transferred into fnancial outcome if the market will honour the management activities. Moreover, as CSR strategies include a bundle of diferent aspects, an increase of a specifc CSR variable, e.g., CSR performance, may also related to future changes in CSR reporting or supply chain management.

According to the business case argument for CSR, frm value, shareholder trust and other stakeholder demands are dependent from each other and gain legitimacy for frms (Dowling and Pfefer 1975). There may be both intrinsic or extrinsic motivation of the top management to implement CSR management systems. Firms with better CSR tools can mainly infuence their fnancial benefts in the long run (e.g., increased cash fows, liquidity) and thus gain better stakeholder reputation (Schaltegger et al. 2019). Stakeholders use CSR measures, e.g., CSR performance or CSR reporting quality, in order to analyse the reliability of CSR management and related frm risks (Velte et al. 2020). If stakeholders assume a low risk of greenwashing policy and information overload in a specifc frm, they may not leave the frm or may increase their engagement with higher frm value as a fnancial consequence (Schaltegger et al. 2019). But certain CSR measures could also increase overall CSR performance as a consequence of professional CSR management, stressing the interlocks between various CSR eforts (e.g., the promotion of gender diversity in boards and their impact on CSR performance) (Byron and Post 2016). As successful CSR eforts should be linked with better stakeholder relations and frm reputation, CSR should also be value relevant for the capital market (Velte and Stawinoga 2017), especially for sustainable investors. Thus, we diferentiate between fnancial performance and CSR performance as frm’s (non) fnancial consequences of CSR strategies.

# 2.5 Research framework

Figure  1 presents an overview of our research framework. In line with the business case argument for CSR and legitimacy theory, CSR (and related subpillars) will be connected with better frms’ (non) fnancial performance. Furthermore, an appropriate corporate governance is needed as a frm-specifc pressure for executive directors to increase their CSR activities and lower the possibility of greenwashing behaviour and self-impression management. Indeed, corporate governance as a monitoring mechanism should lead to higher substantial CSR eforts and thus increased CSR performance and reporting in line with stakeholders’ needs. Thus, the goal of our literature review on prior CSR meta-analyses is a detailed analysis of the corporate governance-related determinants of CSR and their (non) fnancial consequences with a clear focus on fnancial performance. As CSR variables are heterogeneous in empirical-quantitative research, we diferentiate between the most used variables in our review: CSR (and related subpillars) performance and reporting, board gender diversity, sustainable supply chain management (SSCM) and socially responsible investments (SRI). We are also interested in moderator and mediator analyses in this research strength.

![](images/fdd2d5b7c7cee9fa3ec98eb670ab13e14e7fa5abf1bfbf6086904bc0aae5e03b.jpg)  
Fig. 1 Research framework on CSR meta-analyses

Based on legitimacy theory and the business case argument, our analysis focusses on the impact of corporate governance on CSR. We assume that greenwashing and information will be decreased by strict monitoring by the board of directors and shareholders. Then, we assume that successful CSR strategies should lead to increased (non) fnancial performance. The board of directors and shareholders will put pressure on the management to implement substantial CSR management systems. These substantial CSR eforts will strengthen (non) fnancial performance from a long-term perspective. Firm reputation and legitimacy by the society include both fnancial success and CSR performance. However, we are aware of the fact that the research on these two topics is very complex and linked with many interdependencies. Researchers include possible moderator and mediator variables to address those interdependencies. The implementation of moderators and mediators represents one of the major goals of meta-analyses. We like to incorporate prior fndings on CSR meta-analyses whether certain moderators and mediators drive our two relationships. Thus, as a summary, the following three research questions are stated:

1. Which corporate governance determinants infuence CSR in a positive way?   
2. Does CSR lead to increased (non) fnancial performance?   
3. Which moderator and meditator variables infuence the link between corporate governance and CSR on the one hand and frms’ (non) fnancial consequences on the other hand?

Our analysis is based on established papers on conducting high-quality structured literature reviews (Torraco 2005). We identify a major research gap in metaanalyses on the business case for CSR, leading to a closer look on the determinants and consequences of CSR. While CSR-related meta-analyses have increased during the last years, we do not fnd any literature review on prior meta-analyses on that topic. In more detail, we stress that only four literature reviews on metaanalyses in business administration exist so far: a review of accounting (Khlif and Chalmers 2015), auditing (Hay 2019), fnance (Geyer-Klingeberg et al. 2020) and accounting, auditing and corporate governance (Velte 2019b). We see a major research gap on the business case research on CSR, as regulators, practice and research currently controversially discuss whether corporate governance-issues are related to better CSR and whether a stricter regulation on sustainable corporate governance is needed. Moreover, we like to stress top managers’ incentives to increase CSR activities as it may lead to higher fnancial and CSR performance in the long run.

We use several international databases to the end of December 2020 to select our sample of included studies (Web of Science, Google Scholar, SSRN, Ebsco, Science Direct). A targeted search was conducted using the keyword “meta-analysis” in connection with “CSR”, “Sustainability”, “Corporate Social Responsibility”, “CSR Performance”, “CSR Reporting”, “Sustainability Reporting”, “Sustainability Performance”, “gender diversity”, “socially responsible investment”, “sustainable supply chain management” and related terms. We also included broad terms such as “Corporate Governance” and “frm value”. A temporal restriction on the included CSR meta-analyses was not necessary because of the relatively young research tradition. We begin with an initial sample of 71 meta-analyses.

As exclusion criteria, we only recognize quantitative meta-analyses on CSR as our goal is to analyse economic determinants and consequences of CSR. Thus, 5 studies were dropped. In line with other literature reviews, we only include metaanalyses published in English in peer-reviewed journals. Working papers were excluded. This step leads to a reduction of 12 studies. Thus, 54 studies represent the fnal sample of our literature review.

# 3 Main results of CSR meta‑analyses

# 3.1 Content analysis

Prior CSR meta-analyses are characterized by a heterogeneity of collected data, study designs, theoretical approaches, and analytical techniques. Literature reviews have become a relevant research method for scholars, practitioners, and regulators seeking to increase our knowledge about a complex research topic (Webster and Watson 2002). For scholars, a literature review should create new knowledge about CSR using existing meta-analyses that covers the selected topic. A literature review should also contribute to theory development and may close research gaps and revealing precise research recommendations. For practitioners, a literature review gives useful information and insights into efective organizational developments for future business strategies and guidance for policy-making and implementation. As many regulators currently discuss stricter regulations on CSR, sustainable corporate governance, and sustainable fnance, our literature review should guide regulatory bodies in these issues. We present a structured literature review in line with our theoretical foundation and our research framework. We mainly focus on our key research questions, addressing corporate governance-related determinants of CSR, the impact of CSR on (non) fnancial performance, and moderator and mediator variables on these links.

Table  1 gives an overview of the papers per publication year (Panel A), journal (Panel B), content (Panel C) and CSR variables (Panel D). According to Panel A, we note an increased research activity during the last few years (2017–2010) and a rather young research discipline (frst study in 1997). Moreover, referring to Panel C, most meta-analyses in our review have been published in Business Ethics and Sustainability journals, e.g., Business and Society, Business Strategy and the Environment, Corporate Social Responsibility and Environmental Management, or Journal of Business Ethics. Management and corporate governance journal are also included to a higher amount. Most of the meta-analyses address the consequences of CSR, especially the impact of CSR performance on fnancial performance (Panel C). Determinants of CSR are of lower attraction yet. Panel D stresses that CSR performance represents the most important CSR variable included in prior meta-studies.

Table 1 Count of cited published papers   

<html><body><table><tr><td>hshedpapers Panel A: by publication year</td><td></td></tr><tr><td colspan="2">Total: 54</td></tr><tr><td></td><td>2020: 12 2019: 6</td></tr><tr><td></td><td>2018:8</td></tr><tr><td></td><td>2017:4</td></tr><tr><td></td><td></td></tr><tr><td></td><td>2016:4</td></tr><tr><td></td><td>2015:6</td></tr><tr><td></td><td>2014:2</td></tr><tr><td></td><td>2013:4</td></tr><tr><td></td><td>2012: 1</td></tr><tr><td></td><td>2011: 1</td></tr><tr><td></td><td>2010:1</td></tr><tr><td></td><td>2005:1</td></tr><tr><td></td><td>2003:1</td></tr><tr><td></td><td>2001:2 1997: 1</td></tr><tr><td colspan="2">Panel B: by journal</td></tr><tr><td>Total: 54</td><td>Business Ethics/Sustainability journals:29</td></tr><tr><td></td><td>Business and Society: 4</td></tr><tr><td></td><td>Business Ethics Quarterly: 1</td></tr><tr><td></td><td>Business Ethics: 2</td></tr><tr><td></td><td>Business Strategy and the Environment: 3</td></tr><tr><td></td><td>Corporate Social Responsibility and Environmental Management: 3</td></tr><tr><td></td><td>Ecological Economics: 1</td></tr><tr><td></td><td>International Journal of Sustainable Strategic Management: 1</td></tr><tr><td></td><td>Journal of Business Ethics: 4</td></tr><tr><td></td><td>Journal of Cleaner Production: 1</td></tr><tr><td></td><td>Journal of Industrial Ecology: 2</td></tr><tr><td></td><td>Organization and Environment: 1</td></tr><tr><td></td><td>Social Indicators Research: 1</td></tr><tr><td></td><td>Social Responsibility Journal: 2</td></tr><tr><td></td><td>Sustainability: 3</td></tr><tr><td></td><td>Accounting and corporate finance journals: 5</td></tr><tr><td></td><td>Asia-pacific financial studies: 1</td></tr><tr><td></td><td>International journal of accounting and information management: 1</td></tr><tr><td></td><td>International Review of Financial Analysis:1</td></tr><tr><td></td><td>Journal of International Accounting Research:1</td></tr><tr><td></td><td>Journal of Sustainable Finance and Investment:1</td></tr></table></body></html>

Table 1 (continued)   

<html><body><table><tr><td>Panel B: by journal</td><td></td></tr><tr><td></td><td>Management/corporate governance journals:20 Academy of Management Journal: 1</td></tr><tr><td></td><td></td></tr><tr><td></td><td>Asia Pacific Journal of Management: 1</td></tr><tr><td></td><td>Corporate governance: 1</td></tr><tr><td></td><td>Corporate ownership and control: 1</td></tr><tr><td></td><td>European Management Journal: 1</td></tr><tr><td></td><td>International Journal of Production Economics: 1</td></tr><tr><td></td><td>Journal of Business and Psychology: 1</td></tr><tr><td></td><td>Journal of Family Business Management: 1</td></tr><tr><td></td><td>Journal of Management Control: 1</td></tr><tr><td></td><td>Journal of Management Studies: 1</td></tr><tr><td></td><td>Journal of Management: 2</td></tr><tr><td></td><td>Journal of Managerial Issues:1</td></tr><tr><td></td><td>Journal of Promotion Management:1</td></tr><tr><td></td><td>Journal of Supply Chain Management: 1</td></tr><tr><td></td><td>Organization Studies:1</td></tr><tr><td></td><td>PLOS one: 1</td></tr><tr><td></td><td>Procedia Manufacturing: 1</td></tr><tr><td></td><td>Revue de Gestion des Ressources Humanies:1</td></tr><tr><td></td><td>Transportation Research: 1</td></tr><tr><td>Panel C: by content</td><td></td></tr><tr><td>Total: 54</td><td>Corporate governance-related determinants of CSR: 11 Firms&#x27;(non) financial consequences of CSR: 43</td></tr><tr><td>PanelE:by CSR variable</td><td></td></tr><tr><td>Total: 54</td><td></td></tr><tr><td></td><td>CSR performance: 21 CSR reporting: 5</td></tr><tr><td></td><td>CSR reporting/performance: 6</td></tr><tr><td></td><td></td></tr><tr><td></td><td>Environmental management/performance: 9</td></tr><tr><td></td><td>Gender board diversity: 4</td></tr><tr><td></td><td>Social performance: 1</td></tr><tr><td></td><td>Socially responsible investments (SRI): 3</td></tr><tr><td></td><td>Sustainability/green supply chain management: 5</td></tr></table></body></html>

Table 2 gives an overview about included moderator and mediator variables. One of the main advantages of meta-analyses is to identify possible moderator and mediator variables. With few exceptions, most papers include moderators (51). Methodological moderator variables are recognized in nearly every meta-analysis, while the diferentiation of measures of independent and dependent variables is rather common (29). Moreover, frm-specifc variables, e.g., industry, and country-related governance factors, e.g. cultural aspects, are important in our literature review. In contrast to this, accounting and corporate governance-related moderators are rarely included yet. We also note a very low amount of mediator variables in prior CSR meta-analyses (3).

# 3.2 Corporate governance determinants

We already noted that many meta-analyses relate on determinants of CSR as dominant research topic. In line with prior literature (Velte 2019b), we diferentiate between internal corporate governance (board composition) and external corporate governance (ownership structure) with a focus on board composition measures. The average number of included studies within the meta-analyses is rather low (24–158). In our literature review, we mention those studies with a relatively high and low amount of included studies. A possible reason for this is the restricted amount of single studies on the link between corporate governance and CSR. All of our included studies with a specifc description of the applied procedures included random-efects models, assuming the variability between efect sizes is due to sampling error in addition to the variability in the population. Most of prior meta-analyses on the link between corporate governance and CSR included bivariate meta-analyses. A bivariate meta-analysis is a special type of meta-analysis that summarises the results from separately performed diagnostic test studies while keeping the two-dimensionality of the data.

# 3.2.1 Internal corporate governance (board composition)

The main duty of the board of directors is to monitor the executive directors in line with stakeholders’ interests (Byron and Post 2016; Maroun 2020; Wintoki et  al. 2012). During the last decade, many diferent board characteristics were implemented in order to analyse board efectiveness. Board efectiveness should lead to increased executives’ incentives to rely on CSR activities. In this literature review, we note a research intensity on board independence, board gender diversity, board size, board activity and CEO duality as main determinants of CSR performance and reporting.

Board independence represents one major requirement of board efectiveness, as non executives should conduct their monitoring tasks without major conficts of interests in line with stakeholders’ needs. There are clear indications that board independence signifcantly increases both CSR performance (Endrikat et al. 2020; Ortas et al. 2017) and CSR reporting (Lagasio and Cucari 2019; Velte 2019a; Guerrero-Villegas et  al. 2018). However, Majumder et  al. (2017) found insignifcant results, based on just 29 included studies. During the last decade, board gender diversity also gets main attraction in CSR research. A greater range of board diversity, especially with regard to gender, should lead to increased awareness of CSR strategies. Thus, prior meta-analyses state that board gender diversity is linked with better CSR performance (Endrikat et al. 2020; Byron and Post 2016) and CSR reporting (Lagasio and Cucari 2019; Velte 2019a; Guerrero-Villegas et  al. 2018). Again, Majumder et al. (2017) did not fnd any signifcant results. Board size and board activity are our next internal corporate governance determinants in our literature review. Literature assumes that an appropriate board size and board meeting frequency are necessary to guarantee board efectiveness (Endrikat et al. 2020). With regard to board size, there are indications of a positive impact on both CSR performance (Endrikat et  al. 2020; Zubeltzu-Jaka et  al. 2020) and CSR reporting (Lagasio and Cucari 2019; Guerrero-Villegas et  al. 2018; Majumder et  al. 2017). However, Velte (2019a) did not fnd any signifcant impact on CSR reporting. Board activity is of lower relevance yet. According to Majumder et al. (2017), board meetings and CSR reporting are positively related, while insignifcant results are also available (Lagasio and Cucari 2019). Heterogeneous results can be stated for CEO duality. From a theoretical perspective, CEO duality can either contribute to better board efectiveness and CSR activities or may be linked to a reduced monitoring activity with regard to powerful and opportunistic CEOs. Most of the included meta-analyses stated a non-signifcant relationship between CEO duality and CSR (Endrikat et al. 2020; Lagasio and Cucari 2019; Velte 2019a; Majumder et al. 2017). According to Guerrero-Villegas et  al. (2018), CEO duality decreases CSR reporting. Le et al. (2015) is the only study in our review with a focus on top managements’ values and demographic characteristics. The authors just included 29 studies and found that stakeholder values and diversity in experience of top managers are related with increased CSR performance. However, CEO ethical leadership, age and tenure are not related with CSR (Le et al. 2015). We also identify one study on the determinants of board gender diversity (Halliday et al. 2020), based on 158 included studies. The authors found female CEO, female chairperson, CEO duality and board independence to have a positive impact on board gender diversity, while board age decreases it.

Table 2 Included meta-analyses in the literature review grouped by moderating and mediator variables   

<html><body><table><tr><td colspan="2">lable2Includedmeta-analysesin the literaturereviewgrouped bymoderatingand mediator variables</td></tr><tr><td>Moderating variables *</td><td>Numbe</td></tr><tr><td>Included</td><td>51 3</td></tr><tr><td>Not included</td><td></td></tr><tr><td>Firm specific moderating variables:39</td><td></td></tr><tr><td>Development stage</td><td>1 4</td></tr><tr><td>Environmental strategy</td><td></td></tr><tr><td>Export orientation</td><td>2 1</td></tr><tr><td>Firm reputation</td><td>1</td></tr><tr><td>Firm risk mitigation</td><td>6</td></tr><tr><td>Firm size</td><td>11</td></tr><tr><td>Industry</td><td></td></tr><tr><td>Innovation level</td><td>3</td></tr><tr><td>Market conditions</td><td></td></tr><tr><td>Organizational form</td><td>3</td></tr><tr><td>Product type</td><td>1</td></tr><tr><td>Region</td><td>4 1</td></tr><tr><td>Stakeholder reciprocation</td><td></td></tr><tr><td>Accounting and corporate governance specific moderating variables: 5</td><td></td></tr><tr><td>Board independence</td><td>1</td></tr><tr><td>Board meeting frequency</td><td>1</td></tr><tr><td>Board size</td><td>2</td></tr><tr><td>Employees’ age and gender</td><td>1</td></tr><tr><td>Main country specific moderating variables: 30</td><td></td></tr><tr><td>Code law</td><td>3</td></tr><tr><td>Commitment to sustainable goals</td><td>1</td></tr><tr><td>Cultural aspects (Hofstede)</td><td>5</td></tr><tr><td>Developed/developing country</td><td>6</td></tr><tr><td>Economic fluctuations</td><td>1</td></tr><tr><td>Environmental policy</td><td>1</td></tr><tr><td>Gender parity</td><td>5</td></tr><tr><td>Governance framework</td><td></td></tr><tr><td>Income</td><td></td></tr><tr><td>Labor protection</td><td></td></tr><tr><td>Legal enforcement</td><td>4</td></tr><tr><td>Shareholder protection</td><td></td></tr><tr><td>Main research method specific moderating variables: 73</td><td>4</td></tr><tr><td>Choice of controls</td><td>7</td></tr><tr><td>Country</td><td>29</td></tr><tr><td>Measures of independent and/or dependent variables</td><td>3</td></tr><tr><td>Methods of regression</td><td>7</td></tr><tr><td>Publication bias</td><td>7</td></tr><tr><td>Research design</td><td>2</td></tr><tr><td>Sampling</td><td>9</td></tr><tr><td>Time frame</td><td>12</td></tr><tr><td>Mediator variables*</td><td></td></tr><tr><td>included</td><td></td></tr><tr><td>not included</td><td></td></tr><tr><td></td><td>52</td></tr><tr><td>CSR committee</td><td>1</td></tr><tr><td>Organizational justice, trust and identification</td><td>1 1</td></tr><tr><td>Reputation building,competencies,learning and eficiency</td><td></td></tr></table></body></html>

\*Studies may recognize more than one moderator or mediator variable

As the key goal of meta-analyses is to identify and analyse possible moderators and mediators of CSR, we also stress the key results. In this context, we note a very low attractiveness of mediator analysis in prior meta-analyses. One exception is Endrikat et al. (2020), who found a signifcant mediator infuence of CSR committees on the impact of selective board composition variables on CSR performance.

With regard to moderators, board independence and code law regimes strengthen the positive infuence of board size on CSR performance (Zubeltzu-Jaka et  al. 2020). This is in line with the moderating impact of civil law regimes on the link between board independence and CSR performance (Ortas et  al. 2017). Majumder et  al. (2017) found that the diferentiation between developed and developing countries impacts the positive relationship between board size and CSR reporting. Other country-related aspects as signifcant moderator variables are the degree of shareholder protection (Endrikat et  al. 2020; Velte 2019a; Byron and Post 2016), legal enforcement (Velte 2019a), country-related gender parity (Endrikat et al. 2020; Byron and Post 2016), low country commitment to sustainable goals (Guerrero-Villegas et al. 2018) and market conditions (Ortas et al. 2017) with an impact on the relationship between corporate governance variables and CSR. Moreover, countryrelated gender parity weakens the link between a female CEO and board diversity (Halliday et al. 2020). Finally, diferent CSR proxies represent important moderator variables in the included meta-analyses (Endrikat et al. 2020; Ortas et al. 2017 with regard to self-reporting proxies; Le et al. 2015 with regard to social performance).

# 3.2.2 External corporate governance (ownership structure)

External corporate governance is linked with external stakeholders’ monitoring. Prior corporate governance research heavily relies on shareholders as key stakeholders of PIEs. In this context, ownership structure can have a major impact on management strategies. Certain groups of shareholders, mainly sustainable investors, may put pressure on top management to increase CSR strategies in line with other stakeholder interests. Until now, a low research activity on external corporate governance determinants can be found. Canavati (2018) stated a positive infuence of family ownership on CSR performance. This contrasts the results by Lagasio and Cucari (2019) and Majumder et al. (2017) who stressed insignifcant results on ownership structure in general and on government, foreign and institutional ownerships in particular.

With regard to moderator variables, according to Canavati (2018), private family frms and weak labor and corporate governance frameworks positively contribute to the impact of family ownership on CSR performance. Moreover, big four audits have a positive and managerial and concentrated ownership have a negative impact on CSR reporting (Majumder et al. 2017).

# 3.3 Firms’ (non) fnancial consequences of CSR

In line with the business case argument, most archival research on CSR relies on frms’ fnancial consequences. Literature states that both CSR performance and CSR reporting may lead to positive fnancial developments within companies in the long run (e.g., Busch and Friede 2018a). As stakeholders’ demands on CSR-related information and successful CSR strategies increased since the fnancial crisis of 2008–09, high CSR performance and CSR reporting quality may be connected with increased frm reputation, better stakeholder relations and thus higher frm valuation. Next to frm’s fnancial consequences, CSR performance and reporting may have a signifcant impact on other CSR-related consequences. This strength of research addresses the connectivity between various CSR measures. Thus, in our literature review, we separate between fnancial performance and CSR performance on the one hand and between CSR and related subpillars (e.g., environmental performance) on the other hand.

In comparison to Sect. 3.2, we note a higher average amount of studies included in prior meta-analyses on (non) fnancial consequences of CSR (18–437 studies). This can be explained by a relatively long tradition of studies on the CSR-fnancial performance-link and the increased amount of meta-analyses on that topic. In line with our results in Sect.  3.2, random-efects models were dominantly used. One major exception is the use of fxed-efects models on the impact of environmental (green) supply chain management on (non) fnancial performance. Fixed-efects models in meta-analyses assume that there is one true efect size that underlies all the studies in the analysis. While we stress a variety of diferent methods (uni-, bi-, and multivariate meta-analyses), bivariate meta-analyses are mainly used in this research topic. This is line with our remarks in Sect. 3.2. However, we note a relatively high amount of included meta-analyses with a lack of transparency on the applied procedures. This reduces the validity of the analyses.

# 3.3.1 Financial performance

Most of the included meta-analyses on the consequences of CSR address the CSR performance-fnancial performance-link. In this context, a diferentiation between accounting-based (e.g., ROA) and market-based (e.g., Tobin’s Q) measures is common. Some researchers also separate between accounting-, market- and perceptionbased proxies of fnancial performance (Orlitzky et  al. 2001). There are several indications for a positive signifcant impact of CSR performance on fnancial performance (Vishwanathan et al. 2020; Busch and Friede 2018a; Plewnia and Guenther 2017; Hou et  al. 2016; Lu and Taylor 2016; Friede et  al. 2015; Wang et  al. 2016; Quazi and Richardson 2012; Allouche and Laroche 2005; Orlitzky et  al. 2003; Frooman 1997). More specifcally, Busch and Friede (2018a) included 25 prior meta-analysis and state a bidirectional link between CSR and fnanicial performance. According to Hou et al. (2016), the impact is stronger by including environmental performance and operational performance. In a recent study, however, based on 437 included studies, no signifcant results between CSR and fnancial performance can be found (Huang et  al. 2020). Orlitzky and Benjamin (2001) stated a positive bidirectional link between CSR performance and frm risk.

A great variety of moderator variables have been included on this link. Vishwanathan et al. (2020) included 344 studies and have identifed frm reputation, stakeholder reciprocation, frm risk mitigation and innovation level as relevant moderators. Plewnia and Guenther (2017) come to the conclusion, that time lags, region (US-settings), continuous time horizons, controls for advertising intensity and public ownership control moderate the CSR-fnancial performance link. According to Lu and Taylor (2016), referring to 198 CSR studies, long-term efects, environmental performance, non US-settings, pre-2000 studies and multi-industries are relevant moderators. Moreover, journal quality (Busch and Friede 2018a), SMEs, private frms and developing frms (Hou et  al. 2016), environmental performance and developed countries (Wang et al. 2016) and sample size (Quazi and Richardson 2012) moderate this relationship. Orlitzky (2011) referred to 388 CSR studies and stressed that, in comparison to diferent publication outlets, economics journals concentrate on positive signifcant results. This might be a main argument for a problematic publication bias. The diferent measures of CSR and fnancial performance also represent major moderators in the included meta-analyses with a signifcant impact (Busch and Friede 2018a; Hou et  al. 2016; Lu and Taylor 2016; Allouche and Laroche 2005; Orlitzky et al. 2003; Orlitzky and Benjamin 2001). In his main research objective, Orlitzky (2001) concluded that frm size does not moderate the CSR-fnancial performance relationship. Huang et  al. (2020) addressed two main challenges of prior business case research. Economic fuctuations and endogeneity concerns limit the reliability of archival CSR research. The authors found that the elimination of confounding efects of economic fuctuations and the recognition of proper estimation methods due to endogeneity concerns lead to a positive CSRfnancial performance link.

Environmental performance represents one major subpillar of CSR performance. In view of the current climate change discussions from an international perspective, it is not surprising that many prior studies focus on environmental performance as CSR proxy. There are also indications that environmental performance leads to better fnancial performance (Hang et  al. 2019; Endrikat 2016; Endrikat et  al. 2014; Albertini 2013; Dixon-Fowler et  al. 2013). In more detail, Hang et  al. (2019) stressed a short run (1  year) one-way link and a long run bidirectional link (after 1  year). Endrikat et  al. (2014) also reported a partially bidirectional relationship. Furthermore, according to Endrikat (2016), market reactions are stronger negative for negative events than positive for positive events. In a current meta-analysis by Tsai et al. (2020), environmental management also leads to better fnancial performance. Busch and Lewandowski (2018b) included just 32 studies on carbon performance and found a positive impact on fnancial performance. Horvathova (2010) is the only meta-analysis in our review with insignifcant results on the impact of environmental performance on fnancial performance.

We identify a variety of moderator variables on the environmental-fnancial performance link: employees’ age, gender and culture (Wang et  al. 2020), event windows related to event studies (Endrikat 2016), proactive strategic approaches, sampling, addressing endogeneity and fnancial risks (Endrikat et al. 2014), performance measures, regions, industry, time frame (Albertini 2013) and the diferentiation between small frms, public frms and US-settings (Dixon-Fowler et al. 2013). Tsai et al. (2020) stressed that fnancial performance proxies, the year of data collection, industry, economic development and cultural aspects moderate the environmental-fnancial performance link. Moreover, according to Busch and Lewandowski (2018b), specifc performance measures (relative emissions, market based fnancial performance) infuence this relationship.

Next to environmental performance, we note that one meta-analysis also states a positive link between social performance and fnancial performance (Lopez-Arceiz et al. 2018). Size criteria for fnancial performance and social performance based on stakeholder criteria moderate this relationship.

As board gender diversity is controversially discussed with regard to the business case argument, some meta-analyses refer to the impact of female directors on fnancial performance. Hoobler et al. (2018), based on sales performance, and Post and Byron (2015), based on accounting returns, stated a positive impact. However, Pletzer et al. (2015) did not fnd any signifcant relationship. Cultural aspects (Hoobler et  al. 2018), the degree of shareholder protection (Post and Byron 2015) and employees’ perceived CSR and employees’ perception of organization performance (Wang et al. 2020) can be qualifed as main moderator variables on this relationship.

During the last decade, SSCM has gain main attraction in CSR research. The main goal of SSCM is the integration of environmentally and socially viable practices into the full supply chain lifecycle, from product design and development, to material selection, manufacturing, packaging, transportation, warehousing, distribution, consumption, return and disposal. Govindan et  al. (2020) and Golicic and Smith (2013) found a positive impact of SSCM on fnancial performance. Moreover, the branch of industry (manufacturing) (Govindan et  al. 2020; Golicic and Smith

2013), measurements of SSCM, region and time (Golicic and Smith 2013) represent relevant moderator variables.

SRI are investments that are considered socially responsible due to the nature of the business the frm conducts. Common themes for SRI include green and socially conscious investing. SRI can be made into individual companies with good green and social value, or through a socially conscious mutual fund or exchange-traded fund (ETF). Kim (2019), Revelli and Viviani (2015) and Rathner (2013) analyse whether SRI perform better in comparison to conversional funds. The authors state a non-signifcant relationship. As main signifcant moderators, the economic crisis, control groups, the SRI measure, sampling and methodology (Kim 2019), survivorship bias and US focus (Rathner 2013) are recognized.

# 3.3.2 CSR performance

Next to fnancial performance, CSR strategies or subpillars can improve future CSR performance, stressing the various interlinks between CSR variables. This assumption was stated by Gabriel and Nathwani (2014), while this link is more pronounced by proactive CSR strategies. With regard to the link between CSR reporting and CSR performance, Gallardo-Vazquez et  al. (2019) did not fnd any signifcant results. However, region, frm size and CSR disclosure type were included as signifcant moderators (Gallardo-Vazquez et al. 2019). There are also indications that green supply chain management and CSR performance are positively linked (Fang and Zhang 2018; Qorri et al. 2018; Geng et al. 2017). The authors used fxed-efects models as research design. The most important moderators in this context are industry, ISO, export orientation, culture (uncertainty avoidance) (Fang and Zhang 2018), region, industry or frm size (Qorri et al. 2018; Geng et al. 2017).

Doan and Sassen (2020) reported a weak negative infuence of environmental performance on environmental reporting. The diferent proxy variations represent a main moderator variable. According to Erauskin-Tolosa et al. (2020), environmental management practices lead to better environmental performance, moderated by mature certifcation and environmental innovation. Finally, CSR performance leads to better brand loyalty (Aljarah and Ibrahim 2020), customer relationship quality (Aljarah et  al. 2020) and increased employees’ attitudes and behaviour (Zhao et al. 2020). The innovation level and the manufacturing industry weaken the link between CSR and brand loyalty. Cultural collectivism, experience product types and online survey designs strengthen the link (Aljarah and Ibrahim 2020). The relationship between CSR and customer relationship quality is even stronger by customer relationship proxy trust (Aljarah et al. 2020). Organizational justice, trust and identifcation mediate the link between CSR and employees’ attitudes and behaviour (Zhao et al. 2020).

# 3.4 Key results

With regard to corporate governance determinants, we fnd that board independence, board gender diversity and board size have a positive impact on CSR performance. These results are in line with the assumption that corporate governance and CSR represent two dependent disciplines (sustainable corporate governance). As CSR activities can be used for greenwashing policy and self-impression management, corporate governance attributes strengthen monitoring quality, and incentive alignment and put pressure on top managers to include substantial CSR strategies. Moreover, according to our literature review, both CSR performance and environmental performance lead to increased fnancial performance. Thus, frm can follow the business case argument for CSR and may increase their frm value. Other relationships in this literature review are inconclusive. The amount of meta-analyses are either too low or these studies found insignifcant results (e.g., CEO duality, SRI out-performance). This leaves room for many research recommendations in the next chapter. Figure 2 summarize our key results and Table 3 gives a detailed overview of included meta-analyses on CSR.

# 4 Research recommendations

# 4.1 Internal corporate governance

Due to the lack of standardization of CSR, we stress a high degree of managerial discretion (e.g., by the choice of CSR reporting frameworks or performance measures), leading to a low comparability of CSR proxies over time and between PIEs (Mahoney et  al. 2013). Furthermore, greenwashing and impression management mainly infuence CSR activities and may be connected with symbolic use of CSR. Our literature review on prior CSR meta-analyses indicates that the majority of included studies concentrate on CSR performance as main proxy, fnancial performance as major consequence of CSR and variations of CSR measures as moderator variables. We recommend to conduct future meta-analyses on other corporate governance determinants, e.g., sustainable board expertise, on CSR reporting and subpillars of CSR, e.g., carbon reporting. As current discussions heavily rely on carbon performance and disclosure, we know very little about the overall efects of corporate governance on carbon-related issues (Doan and Sassen 2020). Moreover, as mediator analyses are very low in amount (Endrikat et al. 2020), other corporate governance variables may mediate the impact of CSR on fnancial outputs. In this context, future moderators should be more linked with the separation between symbolic/substantive and extrinsic/intrinsic motivations of senior managers in view to CSR strategies. Interestingly, the reliability of CSR performance and reporting by voluntary CSR assurance services, e.g., by professional accountants, is not included in meta-analytical research designs yet (Velte and Stawinoga 2017). Next to classical content analysis and scoring method, advanced methods of textual analysis (e.g., by the use of artifcial intelligence, recognition of social media) can mainly impact the future empirical business case research on CSR e.g., by including readability measures or by analysing tone management. The current focus on archival (secondary) studies with regard to CSR research and their recognition in quantitative metaanalyses should be complemented by experimental designs in order to include individual preferences of various stakeholder groups.

![](images/d6dbfea2d4fb9649735e736beabc4b42147514a2c220bc1410714578fc1a8e20.jpg)  
Fig. 2 Key results of our literature review

Furthermore, individual manager characteristics and traits, e.g. by the CEO and other members of the top management team, should be included in meta-analytical designs. In line with upper echelons theory (Hambrick and Mason 1984), behavioural corporate governance aspects might also infuence CSR strategies. CEO, CFO or other Chief ofcers characteristics, e.g. education and professional backgrounds, personality and preferences, as well as sustainability-related attitudes, should be addressed. In line with the monitoring role of corporate governance mechanisms, incentive alignment between managers and stakeholders can be mainly achieved by sustainable management compensation systems. As Winschel and Stawinoga (2019) conduct a literature review on the determinants and consequences of sustainable CEO compensation, we do not fnd any meta-analysis on this important topic yet.

# 4.2 External corporate governance

Interestingly, external corporate governance factors (ownership structure) are rarely used in comparison to board composition. We know very little about the impact of diferent types of investors on CSR in view of their time horizon and their (non) fnancial interests. However, traditional corporate governance research has a main focus on ownership structure and their impact on fnancial performance. In line with the portfolio theory, shareholders’ investment decisions are linked with considerations of risk and return (Cumming and Johan 2007; Hoq et  al. 2010; Faller and Knyphausen-Aufseß 2018). While institutional investors are primarily focused on fnancial results and investment risks, SRIs explicitly consider ESG aspects in their investment decisions (Clark and Hebb 2005). The time horizon of institutional investors plays an important role in this context (Cox et al. 2004). Thus, long- and short-term investors on the one hand, and active and passive institutions on the other hand, realise diferent investment strategies (Soliman et  al. 2013). Future metaanalyses should include the impact of institutional ownership on CSR due to the increased amount of studies on that topic.

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td colspan="8">PanelA: corporate governance-related determinants of CSR 2020 Endrikat et al. Business and 82</td></tr><tr><td></td><td></td><td>Society</td><td>Bivariate meta- analysis Random effects</td><td>Board characteristics CSR performance (board size,board independence, board gender diversity, CEO duality)</td><td></td><td>Mediator: CSR committee Moderators: share- holder protection, gender parity, dimension of CSR (S,E or aggregate)</td><td>+ (directly and indirectly; not CEO duality) Mediator: + Moderator: +</td></tr><tr><td>2020</td><td>Halliday et al.</td><td>Journal of Business and Psychology</td><td>158 Bivariate meta- analysis Random effects</td><td>Board characteristics Gender board (CEO duality, CEO age, female CEO, female chairperson, board member average age,board inde- pendence,board ownership,family</td><td>diversity</td><td>National context for gender equality (world economic forum global gen- der gap index)</td><td>+(female CEO, female chairperson, CEO duality, board independence) -(board age) Moderator: weaker for female CEO</td></tr><tr><td>2020</td><td>Zubeltzu-Jaka et al.</td><td>Corporate Social Environmental Management</td><td>80 Responsibility and Multivariate meta- analysis Random effects</td><td>Board size</td><td>CSR performance (self-reporting, external reported or archival)</td><td>Board independ- ence, code law</td><td>+ Moderator:+(inde- pendence,code law)</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media- tors</td><td>Significant results</td></tr><tr><td>2019</td><td>Lagasio and Cucari</td><td>Corporate Social Environmental Management</td><td>24 Responsibility and Bivariate meta- analysis Random effects</td><td>Corporate govern- ance (board size, board independ- ence,board gender diversity,board meetings, CEO duality, institu-</td><td>CSR reporting</td><td></td><td>+(board independ- ence, board size, board gender diversity)</td></tr><tr><td>2019</td><td>Velte</td><td>Corporate Owner- ship andcontrol</td><td>51 Bivariate meta- analysis n.A</td><td>Board composition (board independ- ence, CEO duality, gender diversity, board size)</td><td>vidual, external ratings)</td><td>CSR reporting (indi- Shareholder protec-+(board independ- tion,legal enforce- ment, code law</td><td>ence,board gender diversity) Moderator: +share- holder protection,</td></tr></table></body></html>

<html><body><table><tr><td>Yearof oublica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random-versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2018</td><td>Canavati</td><td>Jourmal of Family Business Manage- ment</td><td>97 Bivariate meta- analysis Random effects</td><td>Family ownership (private versus public,family ownership and management versus one of these factors)</td><td>CSR performance (internal versus external)</td><td>Measurement of family and CSR, labor protection, environmental pol- icy and corporate governance regu- latory framework, country cultural</td><td>+ Moderator: private family firms+, family ownership and management+, weak labor and corporate govern- ance regulatory</td></tr><tr><td>2018</td><td>Guerrero-Villegas et al.</td><td>Sustainability</td><td>88 Bivariate meta- analysis n.A</td><td>Board attributes (board independ- ence, CEO duality, board size, gender diversity)</td><td> CSR reporting</td><td>Country&#x27;s commit- ment to sustain- able goals</td><td>- (CEO dual- ity);+(board independence, board size, gender diversity) Moderator:+（low level of commit-</td></tr></table></body></html>

<html><body><table><tr><td>earof blica- on</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>tors</td><td>Moderators/media-Significant results</td></tr><tr><td>017</td><td>Ortas et al.</td><td>Sustainability</td><td>87 Multivariate meta- analysis Random effects</td><td>Board independence (percentage of independent direc- tors, percentage of non executive/ outside directors)</td><td>CSR performance (individual scores based on CSR reporting,archival/ external CSR per- formance ratings, e.g. TRI, KLD, Asset4,Bloomb- erg, Jantzi and Hexun)</td><td>Corporate govern- law, common law, mixed law,others), CSR performance measures,market conditions (from 2010 to 17, from 07 to 09,from 02 to 06,before</td><td>+ ance systems (civil Moderators:+(civil law, CSR self- reporting proxy, market conditions</td></tr></table></body></html>

<html><body><table><tr><td>Yearof oublica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2017</td><td>Majumder et al.</td><td>International Journal 29 of Accounting and Information Management</td><td>Bivariate meta- analysis n.A</td><td>Corporate govern- ance variables (board size, meet- ing frequency, big four audit, board independ- ence,board gender diversity, percentage of non executive direc- tors, government ownership,foreign ownership,institu- tional ownership, managerial owner- ship,concentrated</td><td>CSR reporting</td><td>Developed and developing coun- tries</td><td>+(board size,board meetings, big four audits） - (managerial owner- ship, concentrated ownership) Moderator:+(board size)</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media- tors</td><td>Significant results</td></tr><tr><td>2016</td><td>Byron and Post</td><td>Corporate Govern- ance</td><td>87 Bivariate meta- analysis Random effects</td><td>Women on boards of CSR performance directors</td><td></td><td>Country specific cri- + teria: shareholder protection (world bank)and gender parity (World Eco- nomic Forum&#x27;s Global Gender gap</td><td>Moderator: stronger shareholder protec- tion+,gender parity+</td></tr><tr><td>2015</td><td>Le et al.</td><td>Journal of Manage- rial Issues</td><td>29 Multivariate meta- analysis Random effects</td><td>Top Managers’ stakeholder values (e.g., CEO ethical leadership, CEO values)and demo- graphic character- istics (age,tenure, experience)</td><td>CSR performance (type as strategic versus social)</td><td>score) Type of CSR measure</td><td>+(values and diver- sity in experience) Moderator:+(social CSR performance)</td></tr></table></body></html>

<html><body><table><tr><td>Yearof oublica- ion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td colspan="8">PanelB:firm&#x27;s(non) financialconsequences 2020 Aljarah and Ibrahim Journal of Promo-</td></tr><tr><td></td><td></td><td>tion Management</td><td>43 Bivariate meta- analysis Random effects</td><td>CSR performance</td><td>Brand loyalty</td><td>Cross-cultural variation,level of innovation, indus- try, product type, survey design, sampling</td><td>+ Moderator: level of innovation -; cul- tural collectivism+, product type (expe- rience products)+, industry (manufac- turing)-, survey design (online)+</td></tr><tr><td>2020</td><td>Aljarah et al.</td><td>Social Responsibil- 60 ity Journal</td><td>Multivariate meta- analysis Random effects</td><td>CSR performance</td><td>Customer relation- ship quality (satis- faction, trust and commitment)</td><td>Developed versus developing coun- tries</td><td>+(commitment strongest effect) Moderator:+(only trust)</td></tr><tr><td>2020</td><td>Doan and Sassen</td><td>Journal of Industrial62 Ecology</td><td>Multivariate meta- analysis Random effects</td><td>Environmental performance (per- formance aspect, measurement technique, impact direction, firm adjustment)</td><td>Environmental dis- closure (reporting aspect, measure- ment technique, quality aspect, index adjustment)</td><td>Measurement of environmental performance, measurement of environmental disclosure</td><td>- (weak) Moderators:+</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media- tors</td><td>Significant results</td></tr><tr><td>2020</td><td>Govindan et al.</td><td>Transportation Research Part E</td><td>129 Bivariate meta- analysis Random effects</td><td>Sustainability supply chain management (environmental,</td><td>Firm performance (financial,opera- tional)</td><td>Industry,devel- oped/developing economy</td><td>+ Moderator: manufac- turing +</td></tr><tr><td>2020</td><td>Huang et al.</td><td>International Review 437 of Financial Analysis</td><td>Multivariate meta- analysis N.A</td><td>CSR performance</td><td>Financial perfor- mance (accounting based, market based, perception based)</td><td>Economic fluctua- tions, estimation methods (endoge- neity concerns)</td><td>+/1 Moderator: +by eliminating the confounding effect of economic fluc- tuations and proper</td></tr><tr><td>2020</td><td>Tsai et al.</td><td>Business Strategy and the Environ- ment</td><td>92 Bivariate meta- analysis n.A</td><td>Environmental Man- Financial perfor- agement Practices</td><td>mance</td><td>Performance proxy, year of data col- lection, industry, economic develop- ment, cultural aspects (Hofstede)</td><td>estimation methods + Moderators: +</td></tr><tr><td>2020</td><td>Vishwanathan et al.</td><td>Journal of Manage- ment Studies</td><td>344 Bivariate meta- analysis n.A</td><td>Strategic CSR per- formance</td><td>Financial perfor- mance (accounting based, market based)</td><td>Enhancing firm rep- utation,increas- ing stakeholder reciprocation, mitigating firm risk,innovation capacity</td><td>+ Moderators: +</td></tr></table></body></html>

<html><body><table><tr><td>ear of ublica- on</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model) 65</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media- tors</td><td>Significant results</td></tr><tr><td>020</td><td>Wang et al.</td><td>Business Ethics</td><td>Bivariate meta- analysis Random effects</td><td>CSR performance and reporting (employees’per- ceptions)</td><td>Employees’ percep- tion of external prestige and organ- izational support, organizational identification and organizational trust, organiza- tional commitment and organizational justice, work engagement and job satisfaction, job performance, organizational citi- zenship behavior,</td><td>Samples’demo- graphic charac- teristics (age and gender),national culture</td><td>+ Moderators: +</td></tr><tr><td>020</td><td>Zhao et al.</td><td>Journal of Manage- ment</td><td>86 Multivariate meta- analysis N.A</td><td>Perceived CSR performance and reporting</td><td>creativity Employee attitudes and behavior (organizational commitment, job satisfaction, OCB, turn over inten- tion)</td><td>CSR measures Mediator: organi- zational justice, organizational trust, organiza- tional identifica- tion</td><td>Mediator: +</td></tr></table></body></html>

<html><body><table><tr><td>Yearof publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media- tors</td><td>Significant results</td></tr><tr><td></td><td>Erauskin-Tolosa et al.</td><td>Business Strategy and the Environ- ment</td><td>53 Bivariate meta- analysis Random effects</td><td>Environmental Man- agement Practices (Adoption of volun- tary environmental certification ISO 14,001 and Eco- Management and Audit Scheme</td><td>Environmental performance (effi- ciency and emis- sions or separate, innovation)</td><td>Mature certifica- tion,environmen- tal innovation, performance proxy,EMAS or ISO14001, internalization of</td><td>+ Moderator: mature certification+, environmental innovation +</td></tr><tr><td>2019</td><td>Gallardo-Vazquez et al.</td><td>Sustainability</td><td>95 Bivariate meta- analysis n.A</td><td> CSR reporting</td><td>Financial and non financial perfor- mance</td><td>Measurement of performance and organization size, type of organiza- tion,branch of industry, region</td><td>+/1 Moderators: region, disclosure type, measures of firm size +</td></tr></table></body></html>

<html><body><table><tr><td>earof ublica- on</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>019</td><td>Hang et al.</td><td>Business Strategy and the Environ- ment</td><td>142 Bivariate meta- analysis Random effects</td><td>Environmental performance Financial perfor- mance</td><td>Financial perfor- mance Environmental performance</td><td>Publication bias testShort run (1 year):</td><td>financial perfor- mance-environmen tal performance link + Long run (after 1 year): environ-</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2019</td><td>Kim</td><td>Asia-Pacific Finan- cial Studies</td><td>51 Meta-regression Random effects</td><td>Socially responsible investments versus conventional investments</td><td>mance</td><td>Sampling and meth-  +/- odology</td><td>Moderators:+(eco- nomic crisis,control group,investment universe, screening procedure,mutual funds,publication year,author type, control group, issues,risk adjust- ment, weighting</td></tr><tr><td>2018</td><td>Busch and Friede (second tier meta analysis)</td><td>Corporate Social Responsibility and n.A Environmental Management</td><td>25 (meta-analyses) n.A</td><td>CSR performance</td><td>Financial perfor- mance (percep- tional, operational, accounting based)</td><td>Measures of per- formance, time frame, sample size, journal qual- ity, methods</td><td>+(bidirectional) Moderators: perfor- mance (opera- tional) +, journal quality +</td></tr></table></body></html>

<html><body><table><tr><td>Yearof ublica- ion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2018</td><td>Busch and Lewan- dowski</td><td>Journal of Industrial32 Ecology</td><td>Multivariate meta- analysis Random effects</td><td>Carbon perfor- mance (manda- tory/voluntary reporting,direct/ indirect emissions, absolute/relative</td><td>Financial perfor- mance (accounting based,market based)</td><td>Performance meas- ures</td><td>+ Moderators: perfor- mance measures (relative emis- sions+,market</td></tr><tr><td>2018</td><td>Fang and Zhang</td><td>Journal of Cleaner Production</td><td>54 Multivariate meta- analysis Random effects</td><td>reduction) Green supply chain management (internal versus external practices (green purchasing, customer coop- eration, investment recovery, eco-</td><td>Financial, environ- mental and opera- tional performance</td><td>cation, export ori- entation, cultural distance,individu- alism,masculin- ity, uncertainty avoidance, long- term orientation,</td><td>Industry,ISO certifi-+(strongest impact of environmental performance) dimensions (power Moderators: industry ISO, export orienta tion, uncertainty</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td> Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media- tors</td><td>Significant results</td></tr><tr><td>2018</td><td>Hoobler et al.</td><td>Journal of Manage- ment</td><td>78 Bivariate meta- analysis Random effects</td><td>Gender board diversity (CEO, top management teams,board)</td><td>Financial perfor- mance (accounting based and market based)</td><td>Country-level culture (gen- der supportive climate),women&#x27;s unique contribu- tions (board meet- ing frequency,</td><td>+(sales performance) gender egalitarianModerator:+(culture)</td></tr><tr><td></td><td>Lopez-Arceiz et al.</td><td>Social Indicators Research</td><td>83 Multivariate meta- analysis Random effects</td><td></td><td>Financial perfor- mance (accounting based, market based, percep- tion based, size criteria)</td><td>Measurement criteria and organizational characteristics</td><td>+ Moderators: +(size criteria for financial performance; social performance based on stakeholder criteria</td></tr><tr><td>2018</td><td>Qorri et al.</td><td>Procedia Manufac- turing</td><td>85 Bivariate meta- analysis Fixed effects</td><td>Green supply chain management</td><td>Financial and non-financial performance</td><td>Geographical region,industry, firm size</td><td>+ Moderators: +</td></tr><tr><td>2017</td><td>Geng et al.</td><td>International Journal 50 of Production Economics</td><td>Multivariate meta- analysis Fixed effects</td><td>Green supply chain management</td><td>Financial,environ- mental and social performance</td><td>Industry, firm size, ISO certification, export orientation</td><td>+ Moderators: +</td></tr></table></body></html>

<html><body><table><tr><td>Yearof oublica- ion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2017</td><td>Plewnia and Guen- ther</td><td>Jourmal of Manage- ment Control</td><td>45 Bivariate meta- analysis Random effects</td><td>CSR performance (donation dummy, donation amount, elative donations)</td><td>Financial perfor- mance (accounting based, market based)</td><td>Time lags, study design, perfor- mance proxy, sample country, year of sample collection, partial correlation in gen- eral,controls (firm size,industry, advertising inten- sity,past financial performance,</td><td>+ Moderator:+(time lag,USA,continu- ous time horizon, control for advertis- ing intensity, public ownership control)</td></tr><tr><td>2016</td><td>Endrikat</td><td>Journal of Business Ethics</td><td>29 Univariate meta- analysis Random effects</td><td>Environmental performance</td><td>Financial perfor- mance based on event studies</td><td>public ownership) US versus non US sample,events before/after the year 2000, controlled for con- founding events or not,abnormal or cumulative abnormal returns, one day or longer event window</td><td>+(market reactions stronger negative for negative events than positive for positive events) Moderator: event window+</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2016</td><td>Hou et al.</td><td>Asia Pacific Journal of Management</td><td>28 Bivariate meta- analysis Random effects</td><td>CSR performance (environmental, social)</td><td>Firm performance (financial perfor- mance,operational performance)</td><td>Development stage, firm size, organi- zational form, measurement models (archival versus self created</td><td>+(stronger impact of environmen- tal performance; stronger impact on operational perfor- mance) Moderators: +(SME, private firms,devel-</td></tr><tr><td>2016</td><td>Lu and Taylor</td><td>Journal of Interna- tional Accounting Research</td><td>198 Univariate meta- analysis n.A</td><td>CSR performance (environmental, social perfor- mance)</td><td>Financial perfor- mance (accounting based, market based)</td><td>Measurement of performance, long-term effect, sample, industry, country, method</td><td>CSR measures) + Moderator: especially in the long run, environmental per- formance,account- ing based financial performance, non US, pre-2000 stud-</td></tr><tr><td>2015</td><td>Friede et al.</td><td>Journal of Sustain- able Finance and Investment</td><td>25 meta studies (second order) n.A n.A</td><td>CSR performance</td><td>Financial perfor- mance</td><td></td><td>ies, multi-industry +</td></tr></table></body></html>

<html><body><table><tr><td>ear of ublica- on</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media- tors</td><td>Significant results</td></tr><tr><td>015</td><td>Pletzer et al.</td><td>PLOS one</td><td>20 Univariate meta- analysis Random effects</td><td>Board gender diver- sity (percentage)</td><td>Financial perfor- mance (ROA, ROE,and Tobin&#x27;s Q</td><td>Developing/devel- oped country and income (Gross National Income per capita), mean board size</td><td>+/1</td></tr><tr><td>015</td><td>Post and Byron</td><td>Academy of Man- agement Journal</td><td>140 Multivariate meta- analysis Random effects</td><td>Board gender diversity</td><td>Financial perfor- mance (accounting based and market based) Board activities (board monitor- ing, board strategy involvement)</td><td>Country specific cri- teria: shareholder protection (world bank)and gender parity (World Eco- nomic Forum&#x27;s Global Gender gap score)</td><td>+ (accounting returns) Moderator: + (shareholder pro- tection) although the relation- ship between female board representation and market perfor- mance is near zero</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Jourmal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>tors</td><td>Moderators/media-Significant results</td></tr><tr><td>2015</td><td>Revelli and Viviani</td><td>Business Ethics</td><td>85 Univariate meta- analysis Random effects</td><td>Socially responsible investments (SRI)</td><td>Financial perfor- mance</td><td>Measurements</td><td>+/1</td></tr><tr><td>2016</td><td>Wang et al.</td><td>Business and Society</td><td>42 Bivariate meta- analysis Random effects</td><td>CSR performance</td><td>Financial perfor- mance (accounting based,market based, perception based)</td><td>Management strat- egy,,developed versus developing country</td><td>+ (no bidirectional link) Moderators: +envi- ronmental perfor- mance,developed economics</td></tr><tr><td>2014</td><td>Endrikat et al.</td><td>European Manage- ment Journal</td><td>149 Bivariate meta- analysis Random effects</td><td>Environmental per- formance (process based,outcome based, proactive, reactive)</td><td>Financial perfor- mance (market based, accounting based)</td><td>Measurement of performance, controls (firm size, industry,financial risk,R&amp;D,adver- tising, capital intensity, endoge- neity), time frame,</td><td>+(and partially bidi- rectional) Moderators: proac- tive strategic approach+,sample type+,endogene- ity+,financial risk+</td></tr><tr><td>2014</td><td>Gabriel and Nathwani</td><td>International Journal 18 of Sustainable Strategic Manage-N.A ment</td><td>N.A</td><td>CSR performance and reporting (strategies)</td><td>Financial, social and environmental performance</td><td>sample type CSR measures (proactive versus reactive strategies)</td><td>+ Moderator: proac- tive+</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2013</td><td>Albertini</td><td>Organization andEn- 52 vironment</td><td>N.A N.A</td><td>Environmental performance</td><td>Financial perfor- mance (market based, accounting based and organi-</td><td>Measures,regional differences,indus- try, time frame</td><td>Moderators: +</td></tr><tr><td></td><td></td><td>Ethics</td><td>39 Bivariate meta- analysis Random effects</td><td>Environmental performance (emissions, others, self-report or archival measures)</td><td>Financial perfor- mance (time lag, accounting based, market based)</td><td>Measurement of performance,firm size,region, public versus private firms, industry, environmental strategy</td><td>+ Moderators: small firms +,public firms+, USA+</td></tr><tr><td>2013</td><td>Golicic and Smith</td><td>Journal of Supply Chain Manage- ment</td><td>31 Bivariate meta- analysis Fixed effects</td><td>Environmental sup- ply chain manage- ment (upstream, design, production, downstream)</td><td>Financial perfor- mance (market, accounting and operational based)</td><td>Measurement of environmental management and performance, industry,sample region,firm size, time</td><td>+ Moderators: + except for firm size</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2013</td><td>Rathner</td><td>Journal of Business Ethics</td><td>25 Univariate meta- analysis n.A</td><td>Social responsible investments versus conventional investment</td><td>Investment outper- formance (dummy; yes/no)</td><td>Performance evalu- ation, matching, authorship num- bers,survivorship bias, US funds, time period, number of SRI and conventional funds</td><td>Consideration of the survivorship bias and focus on USA increases the outperformance of SRI</td></tr><tr><td>2012</td><td>Quazi and Rich- ardson</td><td>Social Responsibil-51 ity Journal</td><td>Bivariate meta- analysis N.A 388</td><td>CSR performance</td><td>Financial perfor- mance (accounting based, market based)</td><td>Time frame,sample+ ogy</td><td>size and methodol- Moderators: sample size and methodol- ogy</td></tr><tr><td>2011</td><td>Orlitzky</td><td>Business Ethics Quarterly</td><td>Bivariate meta- analysis N.A</td><td>CSR performance</td><td>Financial perfor- mance</td><td>Publication outlet (economics, finance, account- ing journals versus Social Issues Man- agement, Business Ethics or Business and Society</td><td>Economics did not find null or negative CSR-CFP correla- tions</td></tr></table></body></html>

<html><body><table><tr><td>Year of publica- tion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2010</td><td>Horvathova</td><td>Ecological Econom- ics</td><td>37 Bivariate meta- analysis N.A</td><td>Environmental performance</td><td>Financial perfor- mance (accounting based, market based)</td><td>Measurement of performance, methods,lagged years,country, journal quality)</td><td>+/-</td></tr><tr><td></td><td>Laroche</td><td>des Ressources Humanies</td><td>82 Multivariate meta- regression N.A</td><td></td><td>Financial perfor- mance (market based, accounting based, perceptual based)</td><td>USA, journal type, measurement of performance,time frame,method of regression, choice of controls (indus- try, firm size,risk, R&amp;D intensity)</td><td>+ Moderator: measure- ment of perfor- mance (reputation index)+</td></tr><tr><td></td><td>Orlitzky et al.</td><td>Organization Studies 52</td><td>Bivariate meta- analysis N.A</td><td>CSR(reporting, rat- ing,social audits, managerial princi- ples and values)</td><td>Financial perfor- mance (accounting based,market based, perception based)</td><td>Mediators: repu- competencies, learning and efficiency Artefacts, measure- ment strategies tation-building,</td><td>+ Moderator:+account- ing-based financial performance; reputation index</td></tr><tr><td>2001</td><td>Orlitzky</td><td>Journal of Business Ethics</td><td>20 Bivariate meta- analysis Random effects</td><td>CSR performance</td><td>Financial perfor- mance</td><td>Firm size</td><td>Moderator: +/-</td></tr></table></body></html>

<html><body><table><tr><td>Yearof oublica- ion</td><td>Author(s)</td><td>Journal</td><td>Methodological aspects: number of studies method Applied procedures (random- versus fixed effects model)</td><td>Independent variable(s)</td><td>Dependent variable(s)</td><td>Moderators/media-Significant results tors</td><td></td></tr><tr><td>2001</td><td>Orlitzky and Ben- jamin</td><td>Business and Society</td><td>60 Multivariate meta- analysis Random effects</td><td>CSR (reporting, rat- ings, social audits, performance, environmental performance)</td><td>ing based, market based)</td><td>CSR performance and firm risk</td><td>- (bidirectional link) (more pronounced by market risk meas- ures (e.g.beta) than accounting risk (e.g. return on invested capital. Long term</td></tr><tr><td>997</td><td>Frooman</td><td>Business and Society</td><td>27 N.A N.A</td><td>CSR performance (events)</td><td>Financial perfor- mance (stock market reaction)</td><td></td><td>debt ratio) +</td></tr></table></body></html>

Other stakeholder groups, e.g., customers or suppliers, are rarely included in prior empirical-quantitative research on CSR (Winschel and Stawinoga 2019). We know very little about the impact of other stakeholder groups on CSR strategies and a possible moderator infuence. In line with corporate governance, many researchers analyse the impact of country-related governance on CSR, e.g., shareholder rights or cultural aspects. Thus, there are many research gaps in view of conducting metaanalyses on possible determinants of CSR, if the amount of single studies on that topic reaches an appropriate range.

# 4.3 (Non) fnancial consequences of CSR

We already mentioned that most of our included meta-studies focussed on the impact of CSR performance on fnancial performance. But other (non) fnancial consequences also important in recent CSR studies, e.g. the impact of CSR on earnings management or tax avoidance, indicating heterogeneous results. Literature assumes that intrinsic motivations of managers may lead to a negative impact of CSR strategies on both earnings management and tax avoidance (Velte et al. 2020). Opportunistic manager behaviour (greenwashing policies) may lead to a positive relationship between these variables.

In many ways, we know very little about reversed causality in CSR meta-regressions (Endrikat et  al. 2014). A bidirectional link between corporate governancerelated determinants and CSR on the one hand and frms’ (non) fnancial consequences of CSR on the other hand may be more realistic (Endrikat et al. 2014). Increased CSR activities may be the consequence of higher fnancial circumstances and successful CSR management may also lead to increased corporate governance mechanisms in the future. In view of these important endogeneity concerns, future meta-analyses on CSR should explicitly include moderator variables whether included single studies have used “advanced” regression models, e.g., two or three stage least squares (SLS) or generalized method of moments (GMM) models with instrumental variables (Wintoki et  al. 2012). While the amount of meta-analyses on frm’s (fnancial) consequences of CSR has increased during the last years and recent studies increased their number of included studies and samples, we recommend to increase the transparency of explanations of applied procedures. Some meta-analyses do not explicitly include whether they conducted a uni-, bi- or multivariate meta-analysis or whether they have chosen a random- or fxed efects model.

# 5 Summary

Stakeholders of PIEs demand an appropriate CSR management system that includes diversity concepts, CSR reporting and performance measures (Maroun 2020). During the last decade, frm valuation is not only dependent on fnancial performance, but also on environmental and social strategies and successful management strategies on these issues. As a main challenge, greenwashing policy and information overload are main risks in business practice, which have been criticized by many stakeholder groups (Mahoney et al. 2013). With reference to the business case argument for CSR (Schaltegger et al. 2019), it is not clear, whether CSR-oriented frms will have better (non) fnancial performance in the future. Thus, the impact of corporate governance as key determinants of successful CSR practices might be crucial. During the last decade, massive research has been conducted on the corporate governance-related determinants and frm’s (non) fnancial consequences of CSR activities (e.g., Endrikat et  al. 2020). We also recognize many literature reviews (e.g., Velte et al. 2020) and meta-analyses on CSR. However, no literature review on CSR-related meta-analyses exists so far. Prior literature review of meta-analyses only address accounting (Khlif and Chalmers 2015), auditing (Hay 2019), fnance (Geyer-Klingeberg et al. 2020) and accounting, auditing and corporate governance (Velte 2019b) without any focus on CSR. We see a major research gap on focussing CSR meta-analyses, as it is questionable, which corporate governance determinants are most important in prior research and will positively infuence CSR eforts. Moreover, we are interested whether CSR strategies will lead to positive (non) fnancial consequences for frms. Meta-analyses are more suitable for inclusion in literature reviews as single studies because their aggregation of information leads to an increased statistical power (Cafri et al. 2010). It increases our knowledge about archival CSR research because the overall efect of various single studies on CSR can be included. Thus, we ofer the frst comprehensive, legitimacy theory-based framework on the business case of CSR meta-studies. In this context, we systematically include empirical-quantitative meta-analyses on CSR and diferentiate between in- and external corporate governance drivers on the one hand and (non) fnancial performance as main frms’ consequences on the other hand. We are also interested in prior moderator and mediator analysis within meta-analytic designs.

In contrast to narrative literature reviews and single studies, quantitative metaanalyses as an alternative research method become important in CSR research during the last few years. This literature review includes 54 meta-analyses on CSR and states that the majority of quantitative CSR research concentrates on the CSRfnancial performance-link. In line with the business case for CSR, board independence, board gender diversity and board size as key corporate governance factors have a positive impact on CSR performance. These corporate governance determinants seem to be most relevant in prior CSR research and signifcantly promote CSR strategies. Moreover, with regard to frms’ (non) fnancial consequences, both CSR performance and environmental performance lead to increased fnancial performance. There are clear indications that the business case argument for CSR does exit in business practice. However, prior meta-analyses do not mainly address the challenges of symbolic or substantive use of CSR eforts. Mediator analyses are rare and moderator analyses mainly rely on methodological aspects and classical frmrelated attributes (e.g., industry). We propose research recommendations from a methodological and content-related perspective in this literature review in line with our main research questions.

Our analysis is not only useful for researchers, but it also makes a main contribution for regulatory bodies and business practice. First, based on our frst research question, corporate governance mechanisms may promote successful CSR management strategies as an incentive and monitoring tool in line with our business case hypothesis. Executives should be aware of stakeholder pressure in conducting substantial instead of symbolic CSR in order to prevent information overload and greenwashing policy. Firms should clearly integrate CSR issues into their business model and their risk management processes. Second, based on our second research question, a positive link between CSR and fnancial performance includes a proper integration of diferent frm departments and a dynamic dialogue (e.g., fnance and accounting department, IT, marketing, and sustainability) and sustainability expertise in the board of directors. Increased sustainability expertise by managers will strengthen CSR management and a more balanced view of both risks and chances (future value drivers) of intensive CSR investments and reorganization of business strategies. CSR eforts as “pre-fnancials” may be transferred into fnancial outputs from a long-term perspective and increase frm reputation and legitimacy. A stricter link between CSR and fnancial performance may be realistic, if frms switch from classical fnancial reporting and CSR reporting to an integrated report. A clear connectivity between fnancial and CSR information as integrated thinking may have a positive infuence on substantial CSR strategies. Integrated reporting can be also most useful for external valuation by capital market participants and other stakeholders. Thus, a long-term transformation from CSR management to integrated thinking processes as a clear interaction of fnancial and CSR aspects is favorable. Finally, based on our third research question, the impact of corporate governance on CSR and their (non) fnancial consequences are most complex and heterogeneous in business practice. Corporate governance may only be related with increased CSR eforts if a specifc environment is existent (e.g., other frm-related or countryrelated aspects as moderators or mediators). Similar aspects may be most important due to the CSR-fnancial performance link.

Funding Open Access funding enabled and organized by Projekt DEAL.

Open Access This article is licensed under a Creative Commons Attribution 4.0 International License, which permits use, sharing, adaptation, distribution and reproduction in any medium or format, as long as you give appropriate credit to the original author(s) and the source, provide a link to the Creative Commons licence, and indicate if changes were made. The images or other third party material in this article are included in the article’s Creative Commons licence, unless indicated otherwise in a credit line to the material. If material is not included in the article’s Creative Commons licence and your intended use is not permitted by statutory regulation or exceeds the permitted use, you will need to obtain permission directly from the copyright holder. To view a copy of this licence, visit http://creativecommons.org/licen ses/by/4.0/.

# References

Aguilera R, Rupp D, Williams C, Ganapathi J (2007) Putting the S back in CSR: a multi-level theory of social change in organizations. Acad Manag Rev 32:836–863   
Albertini E (2013) Does environmental management improve fnancial performance? A meta-analytical review. Org Environ 26:431–457   
Aljarah A, Emeagwali L, Ibrahim B, Ababneh B (2020) Does corporate social responsibility really increase customer relationship quality? A meta-analytic review. Soc Responsib J 16:28–49   
Aljarah A, Ibrahim B (2020) The robustness of corporate social responsibility and brand loyalty relation: a meta-analytic examination. J Promot Manag 26:1038–1072   
Allouche J, Laroche P (2005) A Meta-analytical investigation of the relationship between corporate social and fnancial performance. Revue de Gestion des Ressour Humaines 21:18–34   
Brown J, Fraser M (2006) Approaches and perspectives in social and environmental accounting: an overview of the conceptual landscape. Bus Strategy Environ 15:103–117   
Busch T, Friede G (2018a) The robustness of the corporate social and fnancial performance relation: a second-order meta-analysis. Corp Soc Responsib Environ Manag 25:583–608   
Busch T, Lewandowski S (2018b) Corporate carbon and fnancial performance. J Ind Ecol 22:745–759   
Byron K, Post C (2016) Women on boards of directors and corporate social performance. a meta-analysis. Corp Gov Int Rev 24:428–442   
Cafri G, Kromrey JD, Brannick MT (2010) A meta-meta-analysis: empirical review of statistical power, type I error rates, efect sizes, and model selection of meta-analyses published in psychology. Multivar Behav Res 45:239–270   
Canavati S (2018) Corporate social performance in family frms: a meta-analysis. J Family Bus Manag 8:235–273   
Clark GL, Hebb T (2005) Why should they care? Environ Plan 37:2015–2031   
Cox P, Brammer S, Millington A (2004) An empirical examination of institutional investor preferences for corporate social performance. J Bus Ethics 52:27–43   
Cumming D, Johan S (2007) Socially responsible institutional investment in private equity. J Bus Ethics 75:395–416   
Deegan C (2002) The legitimising efect of social and environmental disclosures: a theoretical foundation. Account Audit Account J 15(3):282–311   
Dixon-Fowler HR, Slater DJ, Johnson JL, Ellstrand AE, Romi AM (2013) Beyond “does it pay to be green?” A meta-analysis of moderators of the CEP-CFP relationship. J Bus Ethics 112:353–366   
Doan MH, Sassen R (2020) The relationship between environmental performance and environmental disclosure. J Ind Ecol (online frst) 24:1140–1157   
Dowling J, Pfefer J (1975) Organizational legitimacy. Pac Sociol Rev 18:122–136   
Endrikat J (2016) Market reactions to corporate environmental performance related events: a meta-analytic consolidation of the empirical evidence. J Bus Ethics 138:535–548   
Endrikat J, Guenther E, Hoppe H (2014) Making sense of conficting empirical fndings: a meta-analytic review of the relationship between corporate environmental and fnancial performance. Eur Manag J 32:735–751   
Endrikat J, de Villiers C, Guenther TW, Guenther EM (2020) Board characteristics and corporate social responsibility: a meta-analytic investigation. Bus Soc (online frst). https://doi.org/10.1177/00076 50320930638   
Erauskin-Tolosa A, Zubeltzu-Jaka E, Heras-Saizarbitoria I, Boiral O (2020) ISO 14001, EMAS and environmental performance: a meta-analysis. Bus Strategy Environ 29:1145–1159   
Faller CM, Knyphausen-Aufseß D (2018) Does equity ownership matter for corporate social responsibility? J Bus Ethics 150:15–40   
Fang C, Zhang J (2018) Performance of green supply chain management: a systematic review and meta analysis. J Clean Prod 183:1064–1081   
Fernando S, Lawrence S (2014) A theoretical framework for CSR practices: integrating legitimacy theory, stakeholder theory and institutional theory. J Theor Account Res 10:149–178   
Friede G, Busch T, Bassen A (2015) ESG and fnancial performance: aggregated evidence from more than 2000 empirical studies. J Sustain Finance Invest 5:210–233   
Frooman J (1997) Socially irresponsible and illegal behavior and shareholder wealth. Bus Soc 36:221–249   
Gabriel M, Nathwani J (2014) Linkage between frm’s sustainability strategies and corporate performance: a meta-analysis of global studies. Int J Sustain Strateg Manag 4:189–209   
Gallardo-Vazquez D, Barroso-Mendez MJ, Pajuelo-Moreno ML, Sanchez-Meca J (2019) Corporate social responsibility disclosure and performance: a meta-analytic approach. Sustainability 11:1115   
Geng R, Mansouri SA, Aktas E (2017) The relationship between supply chain management and performance: a meta-analysis of empirical evidences in Asian emerging economies. Int J Prod Econ 183:245–258   
Geyer-Klingeberg J, Hang M, Rathgeber A (2020) Meta-analysis in fnance research: opportunities, challenges, and contemporary applications. Int Rev Finance Anal 71:101524   
Gillan SL (2006) Recent developments in corporate governance: an overview. J Corpor Finance 12:381–402   
Golicic SL, Smith CD (2013) A meta-analysis of environmentally sustainable supply chain management practices and frm performance. J Supply Chain Manag 49:78–95   
Govindan K, Rajeev A, Padhi SS, Pati PK (2020) Supply chain sustainability and performance of frms: a meta-analysis of the literature. Transp Res Part E 137:101923   
Guerrero-Villegas J, Perez-Calero L, Hurtado-Gonzalez J, Giraldez-Puig P (2018) Board attributes and corporate social responsibility disclosure: a meta-analysis. Sustainability 10:4808   
Halliday CS, Paustian-Underdahl SC, Fainshmidt S (2020) Women on boards: a metra-analytic examination of the roles of organizational leadership and national context for gender equality. J Bus Psychol (online frst). https://doi.org/10.1007/s10869-019-09679-y   
Hambrick DC, Mason PA (1984) Upper echelons. Acad Manag Rev 9:193–206   
Hang M, Geyer-Klingeberg J, Rathgeber AW (2019) It is merely a matter of time: a meta-analysis of the causality between between environmental performance and fnancial performance. Bus Strateg Environ 28:257–273   
Hay D (2019) The potential for greater use of meta-analysis in archival auditing research. Manag Audit J 34:76–95   
Hoobler JM, Masterson CR, Nkomo SM, Michel EJ (2018) The business case for women leaders. Metaanalysis, research critique, and path forward. J Manag 44:2473–2499   
Hoq MZ, Saleh M, Zubayer M, Mahmud KT (2010) The efect of CSR disclosure on institutional ownership. Pak J Commer Soc Sci 4:22–39   
Horvathova E (2010) Does environmental performance afect fnancial performance? A meta-analysis. Ecol Econ 70:52–59   
Hou M, Liu H, Fan P, Wei Z (2016) Does CSR practice pay of in East Asian frms? Asia Pac J Manag 33:195–228   
Huang XB, Watson L (2015) Corporate social responsibility research in accounting. J Account Lit 34:1–16   
Huang K, Sim N, Zhao H (2020) Corporate social responsibility, corporate fnancial performance and the confounding efects of economic fuctuations: a meta-analysis. Int Rev Financ Anal (online frst) 70:101504   
Khlif H, Chalmers K (2015) A review of meta-analytic research in accounting. J Account Lit 35:1–27   
Kim CS (2019) Can socially responsible investments be compatible with fnancial performance? A metaanalysis. Asia Pac J Financ Stud 48:30–64   
Lagasio V, Cucari N (2019) Corporate governance and environmental social disclosure: a meta-analytical review. Corpor Soc Responsib EnvironManag (online frst) 26:701–711   
Le S, Fuller B, Muriithi S, Walters B, Kroll MJ (2015) The infuence of top managers’ values on corporate social performance: a meta-analysis. J Manag Issues 27:9–27   
Lopez-Arceiz FJ, Bellostas AJ, Rivera P (2018) Twenty years of research on the relationship between economic and social performance: a meta-analysis approach. Soc Indic Res 140:453–484   
Lu WL, Taylor ME (2016) Which factors moderate the relationship between sustainability performance and fnancial performance: a meta-analysis study. J Int Account Res 15:1–15   
Mahoney LS, Thorne L, Cecil L, LaGore W (2013) A research note on standalone corporate social responsibility reports. Crit Perspect Account 24:350–359   
Majumder MTH, Akter A, Li X (2017) Corporate governance and corporate social disclosures. A metaanalytical review. Int J Account Inf Manag 25:434–458   
Maroun W (2020) A conceptual model for understanding corporate social responsibility assurance practice. J Bus Ethics 161:187–209   
O’Donovan G (1999) Managing legitimacy through increased corporate environmental reporting: an exploratory study. Interdiscip Environ Rev 1:63–99 tionship between corporate social and fnancial performance. Bus Ethics Q 21:409–   
Orlitzky M, Benjamin JD (2001) Corporate social performance and frm risk: a meta-analytic review. Bus Soc 40:369–396   
Orlitzky M, Schmidt FL, Rynes SL (2003) Corporate social and fnancial performance: a meta-analysis. Org Stud 24:403–441   
Ortas E, Alvarez I, Zubeltzu E (2017) Firms’ board independence and corporate social performance: a meta analysis. Sustainability 9:1–26   
Parmigiani A, Rivera-Santos M (2011) Clearing a path through the forest: a meta-review of interorganizational relationships. J Manag 37:1108–1136   
Pletzer JL, Nikolova R, Kedzior KK, Voelpel SC (2015) Does gender matter? Female representation on corporate boards and frm fnancial performance. Meta Anal PLoS ONE 10:1–20   
Plewnia F, Guenther E (2017) The benefts of doing good: a meta-analysis of corporate philanthropy business outcomes and its implications for management control. J Manag Control 28:347–376   
Post C, Byron K (2015) Women on boards and frm fnancial performance: a meta-analysis. Acad Manag J 58:1546–1571   
Qorri A, Mujkic Z, Gashi S, Kraslawski A (2018) Green supply chain management practices and company performance: a meta-analysis approach. Proc Manuf 17:317–325   
Quazi A, Richardson A (2012) Sources of variation in linking corporate social responsibility and fnancial performance. Soc Responsib J 8:242–256   
Rathner S (2013) The infuence of primary study characteristics on the performance diferential between socially responsible and conventional investment funds: a meta-analysis. J Bus Ethics 118:349–363   
Revelli C, Viviani JL (2015) Financial performance of socially responsible investing (SRI): what have we learned? A meta-analysis. Bus Ethics Eur Rev 24:158–185   
Schaltegger S, Hörisch J, Freeman RE (2019) Business cases for sustainability: a stakeholder theory perspective. Org Environ 32:191–212   
Shleifer A, Vishny RW (1997) A survey of corporate governance. J Fin 52:737–783   
Shocker A, Sethi P (1973) An approach to incorporating societal preferences in developing corporate action strategies. Calif Manag Rev 15:97–105   
Soliman MM, El Din MB, Sakr A (2013) Ownership structure and corporate social responsibility (CSR): an empirical study of the listed companies in Egypt. http://papers.ssrn.com/sol3/papers.cfm?abstr act_id 2257816   
Torraco RJ (2005) writing integrative literature reviews: guidelines and examples. Human Resour Dev Rev 4:356–367   
Tsai KH, Huang CT, Chen ZH (2020) Understanding variation in the relationship between environmental management practices and frm performance across studies: a meta-analytic review. Bus Strategy Environ 29:547–565   
Velte P (2019a) Does board composition infuence CSR reporting? A meta-analysis. Corp Ownersh Control 16:48–59   
Velte P (2019b) What do we know about meta-analyses in accounting, auditing, and corporate governance? Medit Account Res 27:17–43   
Velte P, Stawinoga M (2017) Empirical research on corporate social responsibility assurance (CSRA): a literature review. J Bus Econ 87:1017–1066   
Velte P, Stawinoga M, Lueg R (2020) Carbon performance and disclosure. J Clean Prod 254:120063   
Vishwanathan P, van Oosterhout HJ, Heugens PPMAR, Duran P, van Essen M (2020) Strategic CSR: a concept building meta-analysis. J Manag Stud 57:314–350   
Wang Q, Dou J, Jia S (2016) A meta-analytic review of corporate social responsibility and corporate fnancial performance: the moderating efect of contextual factors. Bus Soc 55:1083–1121   
Wang Y, Xu S, Wang Y (2020) The consequences of employees‘ perceived corporate social responsibility: a meta-analysis. Bus Ethics Eur Rev 29:471–496   
Webster J, Watson RT (2002) Analyzing the past to prepare for the future: writing a literature review. MIS Q 26:XIII–XXIII   
Winschel J, Stawinoga M (2019) Determinants and efects of sustainable CEO compensation. Manag Rev Q 69:265–328   
Wintoki MB, Linck JS, Netter JM (2012) Endogeneity and the dynamics of internal corporate governance. J Finance Econ 105:581–606   
Zhao X, Wu C, Chen CC, Zhou Z (2020) The infuence of corporate social responsibility on incumbent employees: a meta-analytic investigation of the mediating and moderating mechanisms. J Manag (online frst). https://doi.org/10.1177/0149206320946108   
Zubeltzu-Jaka E, Alvarez-Etxeberria I, Ortas E (2020) The efect of the size of the board of directors on corporate social performance: a meta-analytic approach. Corp Soc Responsib Environ Manag 27:1361–1374